#include <bits/stdc++.h>

using namespace std;

using ll = long long;

const int mxN = 1005;

vector<int> adj[mxN];

void solve() {
    int n, k;
    cin >> n >> k;

    for(int i = 0; i < n; ++i) {
        adj[i].clear();
    }

    for(int i = 1; i < n; ++i) {
        int u, v;
        cin >> u >> v;
        --u, --v;

        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    const int INF = 1e9 + 12;

    auto nadjiNaj = [&](int s) {
        queue<int> q;
        vector<int> dist(n, INF);

        q.push(s);
        dist[s] = 0;

        while(!q.empty()) {
            auto tren = q.front();
            q.pop();

            for(auto e : adj[tren]) {
                if(dist[e] > dist[tren] + 1) {
                    dist[e] = dist[tren] + 1;
                    q.push(e);
                }
            }
        }

        auto it = max_element(dist.begin(), dist.end());
        return make_pair(*it, it - dist.begin());
    };

    int prvi = nadjiNaj(0).second;
    int odg = nadjiNaj(prvi).first;

    cout << odg << '\n';
}

int main() {
    ios::sync_with_stdio(0);
    cin.tie(0);

    int t;
    cin >> t;
    while(t--) solve();
}